wd = cd;
figure(1); clf;
set(gcf,'Position',[-1300 275 1050 1300]);
axes('Position',[0.24 0.12 0.72 0.82]);
for max_swap = [200 400 800] % 1600]
  swaplog = sprintf('%s/log/swaps_%d.log',wd(1:end-4),max_swap);
  data = load(swaplog);
  iter = data(:,1);
  score = data(:,2);
  swaps = data(:,3);
  tMin = data(:,4);
  plot(tMin,score,'o-','MarkerSize',10,'LineWidth',2,'MarkerFaceColor','w');
  hold on;
end
set(gca,'XLim',[0 20],'XTick',[0:5:20]);
set(gca,'FontSize',32);
set(gca,'LineWidth',3);
set(gca,'YTick',(51:2:59)*1e5);
set(gca,'YTickLabel',{'5100K','5300K','5500K','5700K','5900K'});
yl = ylabel('score');
xl = xlabel('minutes');
set(xl,'Position',[10 5050000 0]);
set(yl,'Position',[-5 5.5e6 0]);
plot([0 20],[5850000 5850000],'k--','LineWidth',2);
grid on;
lgd = legend(' \tau = 200',' \tau = 400', ...
   ' \tau = 800'); %,' \tau = 1600','');
set(lgd,'Position',[0.32 0.2 0.25 0.07]);
title('discrete search');

% INSET
axes('Position',[0.57 0.41 0.36 0.31]);
for max_swap = [200 400 800] % 1600]
  swaplog = sprintf('%s/log/swaps_%d.log',wd(1:end-4),max_swap);
  data = load(swaplog);
  score = data(:,2);
  tMin = data(:,4);
  plot(tMin,score,'o-','MarkerSize',10,'LineWidth',2,'MarkerFaceColor','w');
  hold on;
end
set(gca,'YLim',[5796000 5824000]);
set(gca,'XTick',0:5:20,'XLim',[10 20]);
set(gca,'YTick',(58:0.1:58.2)*1e5);
set(gca,'YTickLabel',{'5800K','5810K','5820K'});
grid on;
set(gca,'LineWidth',3);
set(gca,'FontSize',20);
set(gca,'Color',[0.9 0.9 0.9]);
set(gcf,'Color','w');
set(gcf, 'InvertHardcopy','off');
xlabel('minutes');

set(gcf,'PaperPositionMode','auto');
set(gcf,'PaperUnits','inches','PaperSize',[9 11.5]);
print -dpdf fig_discrete.pdf;
